<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../../config/database.php';

$db = Database::connect();

$id = $_GET['id'] ?? null;

if (!$id) {
    die('Invalid booking ID.');
}

/*
|--------------------------------------------------------------------------
| Fetch Booking with Relations
|--------------------------------------------------------------------------
*/
$stmt = $db->prepare("
    SELECT 
        b.*,
        s.service_name,
        c.name AS customer_name,
        c.email,
        c.phone,
        d.name AS driver_name,
        d.phone AS driver_phone
    FROM bookings b
    JOIN services s ON s.id = b.service_id
    JOIN customers c ON c.id = b.customer_id
    LEFT JOIN drivers d ON d.id = b.driver_id
    WHERE b.id = ?
    LIMIT 1
");
$stmt->execute([$id]);
$booking = $stmt->fetch();

if (!$booking) {
    die('Booking not found.');
}

/*
|--------------------------------------------------------------------------
| Fetch Timeline
|--------------------------------------------------------------------------
*/
$stmt = $db->prepare("
    SELECT *
    FROM booking_timeline
    WHERE booking_id = ?
    ORDER BY timestamp ASC
");
$stmt->execute([$booking['id']]);
$timeline = $stmt->fetchAll();

/*
|--------------------------------------------------------------------------
| Status Badge Helper
|--------------------------------------------------------------------------
*/
function statusBadge($status)
{
    switch ($status) {
        case 'pending': return '<span class="badge badge-secondary">Pending</span>';
        case 'assigned': return '<span class="badge badge-primary">Assigned</span>';
        case 'accepted': return '<span class="badge badge-info">Accepted</span>';
        case 'on_the_way': return '<span class="badge badge-warning">On The Way</span>';
        case 'arrived': return '<span class="badge badge-dark">Arrived</span>';
        case 'started': return '<span class="badge badge-success">Started</span>';
        case 'completed': return '<span class="badge badge-success">Completed</span>';
        case 'cancelled': return '<span class="badge badge-danger">Cancelled</span>';
        default: return '<span class="badge badge-light">Unknown</span>';
    }
}
?>

<?php require_once __DIR__ . '/../includes/header.php'; ?>
<?php require_once __DIR__ . '/../includes/sidebar.php'; ?>

<div class="content-wrapper">

<section class="content-header">
<div class="container-fluid">
<h1>Booking Detail</h1>
</div>
</section>

<section class="content">
<div class="container-fluid">

<div class="row">

<!-- LEFT SIDE -->
<div class="col-md-8">

<div class="card">
<div class="card-header bg-dark">
<h3 class="card-title text-white">
Reference: <?php echo htmlspecialchars($booking['booking_reference']); ?>
</h3>
</div>

<div class="card-body">

<h5>Service Information</h5>
<hr>

<p><strong>Service:</strong>
<?php echo htmlspecialchars($booking['service_name']); ?>
</p>

<p><strong>Status:</strong>
<?php echo statusBadge($booking['status']); ?>
</p>

<p><strong>Pickup Address:</strong>
<?php echo htmlspecialchars($booking['pickup_address']); ?>
</p>

<p><strong>Drop-off Address:</strong>
<?php echo htmlspecialchars($booking['dropoff_address']); ?>
</p>

<p><strong>Pickup Date & Time:</strong>
<?php echo date('d M Y H:i',
strtotime($booking['pickup_datetime'])); ?>
</p>

<?php if ($booking['flight_number']): ?>
<p><strong>Flight:</strong>
<?php echo htmlspecialchars($booking['flight_number']); ?>
</p>
<?php endif; ?>

<?php if ($booking['hours']): ?>
<p><strong>Hours:</strong>
<?php echo htmlspecialchars($booking['hours']); ?>
</p>
<?php endif; ?>

<p><strong>Vehicle:</strong>
<?php echo ucfirst($booking['vehicle_type']); ?>
</p>

<p><strong>Price:</strong>
$<?php echo number_format($booking['final_price'], 2); ?>
</p>

</div>
</div>

<!-- Timeline -->
<div class="card">
<div class="card-header">
<h3 class="card-title">Booking Timeline</h3>
</div>
<div class="card-body">

<ul class="timeline timeline-inverse">

<?php foreach ($timeline as $event): ?>

<li>
<i class="fas fa-clock bg-primary"></i>
<div class="timeline-item">
<span class="time">
<i class="far fa-clock"></i>
<?php echo date('d M Y H:i',
strtotime($event['timestamp'])); ?>
</span>
<h3 class="timeline-header">
<?php echo htmlspecialchars($event['status']); ?>
</h3>
</div>
</li>

<?php endforeach; ?>

</ul>

</div>
</div>

</div>

<!-- RIGHT SIDE -->
<div class="col-md-4">

<!-- Customer Info -->
<div class="card">
<div class="card-header">
<h3 class="card-title">Customer</h3>
</div>
<div class="card-body">

<p><strong>Name:</strong>
<?php echo htmlspecialchars($booking['customer_name']); ?>
</p>

<p><strong>Email:</strong>
<?php echo htmlspecialchars($booking['email']); ?>
</p>

<p><strong>Phone:</strong>
<?php echo htmlspecialchars($booking['phone']); ?>
</p>

</div>
</div>

<!-- Driver Info -->
<div class="card">
<div class="card-header">
<h3 class="card-title">Driver</h3>
</div>
<div class="card-body">

<?php if ($booking['driver_name']): ?>

<p><strong>Name:</strong>
<?php echo htmlspecialchars($booking['driver_name']); ?>
</p>

<p><strong>Phone:</strong>
<?php echo htmlspecialchars($booking['driver_phone']); ?>
</p>

<?php else: ?>

<p class="text-muted">No driver assigned.</p>

<a href="assign_driver.php?id=<?php echo $booking['id']; ?>"
class="btn btn-warning btn-block">
Assign Driver
</a>

<?php endif; ?>

</div>
</div>

<!-- Status Update -->
<div class="card">
<div class="card-header">
<h3 class="card-title">Update Status</h3>
</div>
<div class="card-body">

<form method="POST" action="update_status.php">

<input type="hidden"
name="booking_id"
value="<?php echo $booking['id']; ?>">

<select name="status"
class="form-control mb-3">

<option value="pending">Pending</option>
<option value="assigned">Assigned</option>
<option value="accepted">Accepted</option>
<option value="on_the_way">On The Way</option>
<option value="arrived">Arrived</option>
<option value="started">Started</option>
<option value="completed">Completed</option>
<option value="cancelled">Cancelled</option>

</select>

<button type="submit"
class="btn btn-primary btn-block">
Update Status
</button>

</form>

</div>
</div>

</div>

</div>

</div>
</section>

</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
