<?php
require_once __DIR__ . '/../../../app/Models/Company.php';
require_once __DIR__ . '/../../../app/Config/functions.php';
require_login();

$companyModel = new Company();
$company = $companyModel->getCompany();
if (!$company) { echo "<div class='alert alert-warning m-3'>No company information found.</div>"; exit; }
?>

<div class="modal fade" id="viewCompanyModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title"><i class="fas fa-building mr-2"></i>Company Profile</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <div class="text-center mb-3">
          <img src="<?= htmlspecialchars($company['logo_path'] ?? 'assets/img/logo.png') ?>" class="img-thumbnail rounded-circle" width="120" height="120">
          <h4 class="mt-2"><?= htmlspecialchars($company['name']) ?></h4>
          <p class="text-muted mb-0">Registration No: <?= htmlspecialchars($company['registration_no'] ?? '—') ?></p>
        </div>

        <div class="row mt-4">
          <div class="col-md-6">
            <h6><i class="fas fa-map-marker-alt mr-1 text-primary"></i> Address</h6>
            <p><?= nl2br(htmlspecialchars($company['address'] ?? '—')) ?></p>
          </div>
          <div class="col-md-6">
            <h6><i class="fas fa-phone-alt mr-1 text-primary"></i> Contact</h6>
            <p><?= htmlspecialchars($company['contact_no'] ?? '—') ?><br><?= htmlspecialchars($company['email'] ?? '—') ?></p>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-warning" id="editCompanyBtn"><i class="fas fa-edit"></i> Edit</button>
        <button class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
$('#editCompanyBtn').click(function(){
  $('#viewCompanyModal').modal('hide');
  $.get('ajax/company/edit.php', function(html){
    $('#companyModalContainer').html(html);
    $('#editCompanyModal').modal('show');
  });
});
</script>
