<?php
declare(strict_types=1);
require_once __DIR__ . '/../../../app/Config/config.php';
require_once __DIR__ . '/../../../app/Models/Bank.php';
require_once __DIR__ . '/../../../app/Config/functions.php';

require_login();
header('Content-Type: application/json');

try {
    $id = (int)($_POST['id'] ?? 0);
    if ($id <= 0) throw new Exception('Invalid account.');

    $data = [
        'name' => trim($_POST['name'] ?? ''),
        'account_no' => trim($_POST['account_no'] ?? ''),
        'bank_name' => trim($_POST['bank_name'] ?? ''),
        'type' => $_POST['type'] ?? 'bank',
        'remarks' => trim($_POST['remarks'] ?? '')
    ];

    $model = new Bank();
    $success = $model->updateAccount($id, $data);

    echo json_encode(['status' => $success ? 'success' : 'error', 'message' => $success ? 'Account updated successfully.' : 'Update failed.']);
} catch (Throwable $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
