<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();

$rows = $data['rows'] ?? [];
$totalDebit = $data['total_debit'] ?? 0;
$totalCredit = $data['total_credit'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Trial Balance | SGAccount</title>

<!-- AdminLTE & Icons -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">

<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">

<style>
.table td, .table th { vertical-align: middle; }
.text-right { text-align: right; }
.text-success { color: #28a745 !important; }
.text-danger { color: #dc3545 !important; }
.text-muted { color: #6c757d !important; }
</style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<!-- =========================================================== -->
<!-- 🧾 MAIN CONTENT -->
<!-- =========================================================== -->
<div class="content-wrapper p-4">

  <!-- Toolbar -->
  <section class="content-header">
    <?php include __DIR__ . '/partials/toolbar.php'; ?>
  </section>

  <!-- Report Table -->
  <section class="content mt-3">
    <div class="card">
      <div class="card-body">

        <h4 class="mb-3"><strong>Trial Balance Summary</strong></h4>

        <table class="table table-bordered table-striped">
          <thead class="bg-light">
            <tr>
              <th>Account Code</th>
              <th>Account Name</th>
              <th class="text-right">Debit (SGD)</th>
              <th class="text-right">Credit (SGD)</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($rows)): ?>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td><?= htmlspecialchars($r['account_code']) ?></td>
                  <td><?= htmlspecialchars($r['account_name']) ?></td>
                  <td class="text-right <?= $r['total_debit'] > 0 ? 'text-success' : 'text-muted' ?>">
                    <?= number_format($r['total_debit'], 2) ?>
                  </td>
                  <td class="text-right <?= $r['total_credit'] > 0 ? 'text-danger' : 'text-muted' ?>">
                    <?= number_format($r['total_credit'], 2) ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr><td colspan="4" class="text-center text-muted">No records found for this period.</td></tr>
            <?php endif; ?>
          </tbody>
          <tfoot class="bg-light font-weight-bold">
            <tr>
              <td colspan="2">Totals</td>
              <td class="text-right text-success"><?= number_format($totalDebit, 2) ?></td>
              <td class="text-right text-danger"><?= number_format($totalCredit, 2) ?></td>
            </tr>
            <tr>
              <td colspan="2">Balance Check</td>
              <td colspan="2" class="text-center <?= abs($totalDebit - $totalCredit) < 0.01 ? 'text-success' : 'text-danger' ?>">
                <?= abs($totalDebit - $totalCredit) < 0.01
                  ? '<i class="fas fa-check-circle"></i> Balanced'
                  : '<i class="fas fa-exclamation-triangle"></i> Not Balanced (' . number_format($totalDebit - $totalCredit, 2) . ')' ?>
              </td>
            </tr>
          </tfoot>
        </table>

      </div>
    </div>
  </section>
</div>

<!-- Filter Modal -->
<?php include __DIR__ . '/modal-filter.php'; ?>

<?php include __DIR__ . '/../layouts/footer.php'; ?>

</div>

<!-- =========================================================== -->
<!-- 📜 SCRIPTS -->
<!-- =========================================================== -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

<script>
$('#filterForm').on('submit', function(e){
  e.preventDefault();
  const s = $('input[name="start"]').val();
  const eDate = $('input[name="end"]').val();
  window.location = `router.php?page=trial-balance&start=${s}&end=${eDate}`;
});
</script>

</body>
</html>
