<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>General Ledger | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.5/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap4.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-book mr-2"></i> General Ledger</h1>
    <form method="get" action="router.php">
      <input type="hidden" name="page" value="ledger">
      <div class="form-inline">
        <label class="mr-2">Account:</label>
        <select name="account" class="form-control mr-2">
          <option value="">All Accounts</option>
          <?php foreach($accounts as $a): ?>
            <option value="<?= $a['account_code'] ?>" <?= ($_GET['account'] ?? '') == $a['account_code'] ? 'selected' : '' ?>>
              <?= $a['account_code'].' - '.$a['account_name'] ?>
            </option>
          <?php endforeach; ?>
        </select>
        <label class="mr-2">From:</label><input type="date" name="start" class="form-control mr-2" value="<?= $_GET['start'] ?? '' ?>">
        <label class="mr-2">To:</label><input type="date" name="end" class="form-control mr-2" value="<?= $_GET['end'] ?? '' ?>">
        <button class="btn btn-primary"><i class="fas fa-filter"></i> Filter</button>
      </div>
    </form>
  </section>

  <section class="content mt-3">
    <div class="card">
      <div class="card-body table-responsive">
        <table id="ledgerTable" class="table table-bordered table-hover">
          <thead class="bg-light">
            <tr>
              <th>Date</th>
              <th>Journal No</th>
              <th>Account</th>
              <th>Description</th>
              <th class="text-right">Debit (SGD)</th>
              <th class="text-right">Credit (SGD)</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?= htmlspecialchars($r['journal_date']) ?></td>
                <td><a href="router.php?page=journal&id=<?= $r['journal_id'] ?>" class="text-primary"><?= htmlspecialchars($r['journal_no']) ?></a></td>
                <td><?= htmlspecialchars($r['account_code'].' - '.$r['account_name']) ?></td>
                <td><?= htmlspecialchars($r['journal_desc']) ?></td>
                <td class="text-right"><?= number_format($r['debit'],2) ?></td>
                <td class="text-right"><?= number_format($r['credit'],2) ?></td>
                <td><span class="badge badge-<?= $r['status']=='posted'?'success':'warning' ?>"><?= ucfirst($r['status']) ?></span></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.5/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script>
$('#ledgerTable').DataTable({
  dom:'Bfrtip',
  buttons:['excelHtml5','print']
});
</script>
</body>
</html>
