<?php
/**
 * SGAccount – Header Layout
 * -------------------------------------------------------------
 * Top navigation bar with dark-mode toggle, notifications,
 * and user menu. Compatible with AdminLTE 3.2 (CDN version).
 */
declare(strict_types=1);

require_once __DIR__ . '/../../../app/Config/functions.php';
require_once __DIR__ . '/../../../app/Models/User.php';

$userId   = $_SESSION['user_id'] ?? null;
$userName = $_SESSION['user_name'] ?? 'Guest';
$userRole = ucfirst($_SESSION['role'] ?? 'User');

// ------------------------------------------------------------------
// 👤 Load user info
// ------------------------------------------------------------------
$userPhoto = 'assets/img/user.png';
if ($userId) {
    $userModel = new User();
    $user = $userModel->getById((int)$userId);
    if (!empty($user['profile_image'])) {
        $userPhoto = $user['profile_image'];
    }
}
?>
<!-- Main Header -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light border-bottom shadow-sm">

  <!-- Left navbar links -->
  <ul class="navbar-nav">
    <li class="nav-item">
      <a class="nav-link" data-widget="pushmenu" href="#" role="button" title="Toggle Sidebar">
        <i class="fas fa-bars"></i>
      </a>
    </li>
    <li class="nav-item d-none d-sm-inline-block">
      <a href="router.php?page=dashboard" class="nav-link font-weight-bold">Dashboard</a>
    </li>
  </ul>

  <!-- SEARCH FORM -->
  <form class="form-inline ml-3 d-none d-sm-block" action="router.php" method="get">
    <input type="hidden" name="page" value="search">
    <div class="input-group input-group-sm">
      <input class="form-control form-control-navbar" type="search" placeholder="Search..." aria-label="Search" name="q">
      <div class="input-group-append">
        <button class="btn btn-navbar" type="submit"><i class="fas fa-search"></i></button>
      </div>
    </div>
  </form>

  <!-- Right navbar links -->
  <ul class="navbar-nav ml-auto align-items-center">

    <!-- Notifications Dropdown -->
    <li class="nav-item dropdown">
      <a class="nav-link" data-toggle="dropdown" href="#" title="Notifications">
        <i class="far fa-bell"></i>
        <span class="badge badge-danger navbar-badge">3</span>
      </a>
      <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
        <span class="dropdown-header">3 Notifications</span>
        <div class="dropdown-divider"></div>
        <a href="#" class="dropdown-item">
          <i class="fas fa-file-invoice mr-2 text-primary"></i> 2 new invoices
          <span class="float-right text-muted text-sm">5 min</span>
        </a>
        <div class="dropdown-divider"></div>
        <a href="#" class="dropdown-item">
          <i class="fas fa-chart-line mr-2 text-success"></i> Trial Balance updated
          <span class="float-right text-muted text-sm">1 hr</span>
        </a>
        <div class="dropdown-divider"></div>
        <a href="#" class="dropdown-item dropdown-footer">View All Notifications</a>
      </div>
    </li>

    <!-- Dark Mode Toggle -->
    <li class="nav-item">
      <a href="#" class="nav-link" id="darkModeToggle" title="Toggle Dark Mode">
        <i class="far fa-moon"></i>
      </a>
    </li>

    <!-- User Dropdown Menu -->
    <li class="nav-item dropdown user-menu">
      <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
        <img src="<?= htmlspecialchars($userPhoto) ?>" class="user-image img-circle elevation-2" alt="User Image">
        <span class="d-none d-md-inline font-weight-bold"><?= htmlspecialchars($userName) ?></span>
      </a>
      <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
        <!-- User image -->
        <li class="user-header bg-primary">
          <img src="<?= htmlspecialchars($userPhoto) ?>" class="img-circle elevation-2" alt="User Image">
          <p>
            <?= htmlspecialchars($userName) ?> — <?= htmlspecialchars($userRole) ?><br>
            <small>Member since <?= date('Y') ?></small>
          </p>
        </li>

        <!-- Menu Footer-->
        <li class="user-footer d-flex justify-content-between">
          <a href="router.php?page=settings" class="btn btn-default btn-flat">
            <i class="fas fa-user-cog mr-1"></i> Profile
          </a>
          <a href="router.php?page=logout" class="btn btn-default btn-flat text-danger">
            <i class="fas fa-sign-out-alt mr-1"></i> Logout
          </a>
        </li>
      </ul>
    </li>
  </ul>
</nav>

<!-- Dark Mode Script -->
<script>
document.addEventListener('DOMContentLoaded', function () {
  const toggle = document.getElementById('darkModeToggle');
  const body = document.body;

  // Restore saved theme
  if (localStorage.getItem('sgaccount-theme') === 'dark') {
    body.classList.add('dark-mode');
    toggle.innerHTML = '<i class="fas fa-sun"></i>';
  }

  toggle.addEventListener('click', (e) => {
    e.preventDefault();
    body.classList.toggle('dark-mode');
    const isDark = body.classList.contains('dark-mode');
    toggle.innerHTML = isDark
      ? '<i class="fas fa-sun"></i>'
      : '<i class="far fa-moon"></i>';
    localStorage.setItem('sgaccount-theme', isDark ? 'dark' : 'light');
  });
});
</script>
