<?php
/**
 * SGAccount – Dashboard
 * -------------------------------------------------------------
 * Accounting Dashboard with summaries & charts.
 * PHP 8.1.31 | AdminLTE 3.2 | Chart.js
 */

declare(strict_types=1);
require_once __DIR__ . '/../app/Config/functions.php';
require_login();

$title = "Dashboard";

include __DIR__ . '/layouts/header.php';
include __DIR__ . '/layouts/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper p-4">

  <!-- Header -->
  <section class="content-header d-flex justify-content-between align-items-center mb-3">
    <h1><i class="fas fa-tachometer-alt mr-2"></i> Dashboard Overview</h1>
    <span class="badge badge-primary p-2"><?= date('l, d M Y') ?></span>
  </section>

  <!-- Financial Summary Widgets -->
  <div class="row">
    <!-- Total Income -->
    <div class="col-md-3 col-sm-6 col-12">
      <div class="info-box bg-success">
        <span class="info-box-icon"><i class="fas fa-arrow-up"></i></span>
        <div class="info-box-content">
          <span class="info-box-text">Total Income</span>
          <span class="info-box-number">$<?= number_format($financialSummary['income'] ?? 0, 2) ?></span>
          <div class="progress"><div class="progress-bar" style="width:100%"></div></div>
          <span class="progress-description">Revenue earned</span>
        </div>
      </div>
    </div>

    <!-- Total Expenses -->
    <div class="col-md-3 col-sm-6 col-12">
      <div class="info-box bg-danger">
        <span class="info-box-icon"><i class="fas fa-arrow-down"></i></span>
        <div class="info-box-content">
          <span class="info-box-text">Total Expenses</span>
          <span class="info-box-number">$<?= number_format($financialSummary['expense'] ?? 0, 2) ?></span>
          <div class="progress"><div class="progress-bar" style="width:100%"></div></div>
          <span class="progress-description">Total outgoing costs</span>
        </div>
      </div>
    </div>

    <!-- Cash on Hand -->
    <div class="col-md-3 col-sm-6 col-12">
      <div class="info-box bg-info">
        <span class="info-box-icon"><i class="fas fa-wallet"></i></span>
        <div class="info-box-content">
          <span class="info-box-text">Cash on Hand</span>
          <span class="info-box-number">$<?= number_format($financialSummary['cash'] ?? 0, 2) ?></span>
          <div class="progress"><div class="progress-bar" style="width:100%"></div></div>
          <span class="progress-description">Available cash balance</span>
        </div>
      </div>
    </div>

    <!-- Net Profit -->
    <div class="col-md-3 col-sm-6 col-12">
      <div class="info-box <?= ($financialSummary['net'] ?? 0) >= 0 ? 'bg-primary' : 'bg-warning' ?>">
        <span class="info-box-icon">
          <i class="fas <?= ($financialSummary['net'] ?? 0) >= 0 ? 'fa-chart-line' : 'fa-chart-area' ?>"></i>
        </span>
        <div class="info-box-content">
          <span class="info-box-text">Net Profit</span>
          <span class="info-box-number">$<?= number_format($financialSummary['net'] ?? 0, 2) ?></span>
          <div class="progress"><div class="progress-bar" style="width:100%"></div></div>
          <span class="progress-description">
            <?= ($financialSummary['net'] ?? 0) >= 0 ? 'Profitable period' : 'Net loss incurred' ?>
          </span>
        </div>
      </div>
    </div>
  </div>

  <!-- Journal Summary Widgets -->
  <div class="row mt-4">
    <!-- Total Journals -->
    <div class="col-md-3 col-sm-6 col-12">
      <div class="info-box bg-primary">
        <span class="info-box-icon"><i class="fas fa-book"></i></span>
        <div class="info-box-content">
          <span class="info-box-text">Total Journals</span>
          <span class="info-box-number"><?= number_format($journalSummary['total'] ?? 0) ?></span>
          <div class="progress"><div class="progress-bar" style="width:100%"></div></div>
          <span class="progress-description">All journal entries</span>
        </div>
      </div>
    </div>

    <!-- Posted -->
    <div class="col-md-3 col-sm-6 col-12">
      <div class="info-box bg-success">
        <span class="info-box-icon"><i class="fas fa-check-circle"></i></span>
        <div class="info-box-content">
          <span class="info-box-text">Posted</span>
          <span class="info-box-number"><?= number_format($journalSummary['posted'] ?? 0) ?></span>
          <div class="progress">
            <div class="progress-bar" style="width:<?= ($journalSummary['total'] ?? 0) > 0 ? ($journalSummary['posted'] / $journalSummary['total'] * 100) : 0 ?>%"></div>
          </div>
          <span class="progress-description">Officially posted</span>
        </div>
      </div>
    </div>

    <!-- Draft -->
    <div class="col-md-3 col-sm-6 col-12">
      <div class="info-box bg-warning">
        <span class="info-box-icon"><i class="fas fa-pencil-alt"></i></span>
        <div class="info-box-content">
          <span class="info-box-text">Draft</span>
          <span class="info-box-number"><?= number_format($journalSummary['draft'] ?? 0) ?></span>
          <div class="progress">
            <div class="progress-bar" style="width:<?= ($journalSummary['total'] ?? 0) > 0 ? ($journalSummary['draft'] / $journalSummary['total'] * 100) : 0 ?>%"></div>
          </div>
          <span class="progress-description">Pending approval</span>
        </div>
      </div>
    </div>

    <!-- Unbalanced -->
    <div class="col-md-3 col-sm-6 col-12">
      <div class="info-box bg-danger">
        <span class="info-box-icon"><i class="fas fa-exclamation-triangle"></i></span>
        <div class="info-box-content">
          <span class="info-box-text">Unbalanced</span>
          <span class="info-box-number"><?= number_format($journalSummary['unbalanced'] ?? 0) ?></span>
          <div class="progress">
            <div class="progress-bar" style="width:<?= ($journalSummary['total'] ?? 0) > 0 ? ($journalSummary['unbalanced'] / $journalSummary['total'] * 100) : 0 ?>%"></div>
          </div>
          <span class="progress-description">Needs correction</span>
        </div>
      </div>
    </div>
  </div>

  <!-- Financial Trend Charts -->
  <div class="row mt-4">
    <!-- Income vs Expense -->
    <div class="col-md-8">
      <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
          <h5 class="mb-0"><i class="fas fa-chart-line mr-2"></i> Monthly Income vs Expenses</h5>
        </div>
        <div class="card-body">
          <canvas id="incomeExpenseChart" height="120"></canvas>
        </div>
      </div>
    </div>

    <!-- Net Profit -->
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-header bg-success text-white">
          <h5 class="mb-0"><i class="fas fa-chart-bar mr-2"></i> Net Profit Trend</h5>
        </div>
        <div class="card-body">
          <canvas id="netProfitChart" height="120"></canvas>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/layouts/footer.php'; ?>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<!-- Chart Initialization -->
<script>
const chartLabels  = <?= json_encode($trends['labels'] ?? []) ?>;
const chartIncome  = <?= json_encode($trends['income'] ?? []) ?>;
const chartExpense = <?= json_encode($trends['expense'] ?? []) ?>;
const chartNet     = <?= json_encode($trends['net'] ?? []) ?>;

// Income vs Expense Line Chart
new Chart(document.getElementById('incomeExpenseChart').getContext('2d'), {
  type: 'line',
  data: {
    labels: chartLabels,
    datasets: [
      {
        label: 'Income',
        data: chartIncome,
        borderColor: '#28a745',
        backgroundColor: 'rgba(40,167,69,0.2)',
        fill: true,
        tension: 0.4
      },
      {
        label: 'Expense',
        data: chartExpense,
        borderColor: '#dc3545',
        backgroundColor: 'rgba(220,53,69,0.2)',
        fill: true,
        tension: 0.4
      }
    ]
  },
  options: {
    responsive: true,
    plugins: {
      legend: { position: 'bottom' }
    },
    scales: { y: { beginAtZero: true } }
  }
});

// Net Profit Bar Chart
new Chart(document.getElementById('netProfitChart').getContext('2d'), {
  type: 'bar',
  data: {
    labels: chartLabels,
    datasets: [{
      label: 'Net Profit',
      data: chartNet,
      backgroundColor: chartNet.map(v => v >= 0 ? 'rgba(0,123,255,0.8)' : 'rgba(255,193,7,0.8)'),
      borderColor: chartNet.map(v => v >= 0 ? '#007bff' : '#ffc107'),
      borderWidth: 1
    }]
  },
  options: {
    responsive: true,
    plugins: { legend: { display: false } },
    scales: { y: { beginAtZero: true } }
  }
});
</script>
