<?php require_once __DIR__ . '/../../Config/functions.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Customers | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-users mr-2"></i>Customers</h1>
    <button class="btn btn-primary" data-toggle="modal" data-target="#addCustomerModal"><i class="fas fa-plus"></i> Add</button>
  </section>
  <section class="content mt-3">
    <div class="card">
      <div class="card-body">
        <table id="customerTable" class="table table-bordered table-striped">
          <thead><tr><th>Name</th><th>Email</th><th>Contact</th><th>Status</th><th>Action</th></tr></thead>
          <tbody>
            <?php foreach($customers as $c): ?>
            <tr>
              <td><?= htmlspecialchars($c['name']) ?></td>
              <td><?= htmlspecialchars($c['email']) ?></td>
              <td><?= htmlspecialchars($c['contact_no']) ?></td>
              <td><span class="badge badge-<?= $c['status']=='active'?'success':'secondary' ?>"><?= $c['status'] ?></span></td>
              <td>
                <button class="btn btn-sm btn-warning editCustomer" data-id="<?= $c['id'] ?>"><i class="fas fa-edit"></i></button>
                <button class="btn btn-sm btn-danger deleteCustomer" data-id="<?= $c['id'] ?>"><i class="fas fa-trash"></i></button>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>
<?php include __DIR__ . '/modal-add.php'; ?>
<?php include __DIR__ . '/modal-edit.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
  $('#customerTable').DataTable();
  $('#addCustomerForm').on('submit', function(e){ e.preventDefault(); $.post('ajax/customers/add.php', $(this).serialize(), ()=>location.reload()); });
  $('.deleteCustomer').click(function(){ if(confirm('Delete customer?')) $.post('ajax/customers/delete.php',{id:$(this).data('id')},()=>location.reload()); });
  $('.editCustomer').click(function(){ $.get('ajax/customers/edit.php',{id:$(this).data('id')},html=>$('#editCustomerModal .modal-body').html(html).end().modal('show')); });
});
</script>
</body>
</html>
