<?php
declare(strict_types=1);

require_once __DIR__ . '/../../Config/functions.php';
require_login();

include __DIR__ . '/../layouts/header.php';
include __DIR__ . '/../layouts/sidebar.php';

// Ensure company data exists
if (!isset($company) || empty($company)) {
    echo "<div class='content-wrapper p-4'><div class='alert alert-danger'>Company record not found.</div></div>";
    include __DIR__ . '/../layouts/footer.php';
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Company Profile | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="assets/css/custom.css">
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
  <!-- Content Wrapper -->
  <div class="content-wrapper p-4">

    <!-- Page Header -->
    <section class="content-header d-flex justify-content-between align-items-center mb-3">
      <h1><i class="fas fa-building mr-2"></i> Company Profile</h1>
      <a href="router.php?page=company" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to List
      </a>
    </section>

    <!-- Main Content -->
    <section class="content">
      <div class="card shadow-lg border-primary">
        <div class="card-header bg-primary text-white">
          <h3 class="card-title">
            <i class="fas fa-id-badge mr-2"></i><?= htmlspecialchars($company['name']) ?>
          </h3>
        </div>

        <div class="card-body row">
          <!-- Logo Column -->
          <div class="col-md-4 text-center">
            <?php if (!empty($company['logo_path'])): ?>
              <img src="/uploads/<?= htmlspecialchars(ltrim($company['logo_path'], '/')) ?>"
                   alt="Company Logo"
                   class="img-fluid rounded shadow-sm mb-3"
                   style="max-width:250px; border:1px solid #ddd;">
            <?php else: ?>
              <div class="text-muted border p-5 bg-light rounded">No Logo Uploaded</div>
            <?php endif; ?>
          </div>

          <!-- Details Column -->
          <div class="col-md-8">
            <table class="table table-striped">
              <tbody>
                <tr>
                  <th style="width:200px;">Company Name:</th>
                  <td><?= htmlspecialchars($company['name']) ?></td>
                </tr>
                <tr>
                  <th>Registration No:</th>
                  <td><?= htmlspecialchars($company['registration_no'] ?? '-') ?></td>
                </tr>
                <tr>
                  <th>GST No:</th>
                  <td><?= htmlspecialchars($company['gst_no'] ?? '-') ?></td>
                </tr>
                <tr>
                  <th>Email:</th>
                  <td><?= htmlspecialchars($company['email'] ?? '-') ?></td>
                </tr>
                <tr>
                  <th>Phone:</th>
                  <td><?= htmlspecialchars($company['phone'] ?? '-') ?></td>
                </tr>
                <tr>
                  <th>Address:</th>
                  <td><?= nl2br(htmlspecialchars($company['address'] ?? '-')) ?></td>
                </tr>
                <tr>
                  <th>Created At:</th>
                  <td><?= htmlspecialchars($company['created_at'] ?? '-') ?></td>
                </tr>
                <tr>
                  <th>Updated At:</th>
                  <td><?= htmlspecialchars($company['updated_at'] ?? '-') ?></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

        <div class="card-footer text-right">
          <button class="btn btn-info editBtn" data-id="<?= $company['id'] ?>">
            <i class="fas fa-edit"></i> Edit
          </button>
          <button class="btn btn-danger deleteBtn" data-id="<?= $company['id'] ?>">
            <i class="fas fa-trash"></i> Delete
          </button>
        </div>
      </div>
    </section>
  </div>

  <?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(function(){
  // Edit
  $('.editBtn').click(function(){
    const id = $(this).data('id');
    $.get('/ajax/company/edit.php', { id }, function(res){
      try {
        const data = JSON.parse(res);
        $('#edit_id').val(data.id);
        $('#edit_name').val(data.name);
        $('#edit_registration_no').val(data.registration_no);
        $('#edit_address').val(data.address);
        $('#edit_phone').val(data.phone);
        $('#edit_email').val(data.email);
        $('#edit_gst_no').val(data.gst_no);
        $('#editModal').modal('show');
      } catch (e) {
        console.error('Invalid response:', res);
        Swal.fire('Error', 'Failed to load edit form.', 'error');
      }
    });
  });

  // Delete
  $('.deleteBtn').click(function(){
    const id = $(this).data('id');
    Swal.fire({
      title: 'Are you sure?',
      text: 'This action cannot be undone!',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, delete it!'
    }).then(result => {
      if(result.isConfirmed){
        $.post('/ajax/company/delete.php', { id }, function(res){
          Swal.fire('Deleted!', res, 'success').then(() => {
            window.location = 'router.php?page=company';
          });
        });
      }
    });
  });
});
</script>
</body>
</html>
