<?php
declare(strict_types=1);

require_once __DIR__ . '/../../Config/functions.php';
require_login();

include __DIR__ . '/../layouts/header.php';
include __DIR__ . '/../layouts/sidebar.php';

$model = new Coa();
$accounts = $model->getAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Chart of Accounts | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="assets/css/custom.css">
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <!-- Content Wrapper -->
  <div class="content-wrapper p-3">
    <section class="content-header d-flex justify-content-between align-items-center">
      <h1><i class="fas fa-book mr-2"></i> Chart of Accounts</h1>
      <button class="btn btn-primary" data-toggle="modal" data-target="#addCoaModal">
        <i class="fas fa-plus-circle"></i> Add Account
      </button>
    </section>

    <section class="content mt-3">
      <div class="card shadow-sm">
        <div class="card-body table-responsive">
          <table id="coaTable" class="table table-bordered table-striped">
            <thead class="thead-light">
              <tr>
                <th>Code</th>
                <th>Account Name</th>
                <th>Type</th>
                <th>Description</th>
                <th class="text-center">Action</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($accounts as $a): ?>
              <tr>
                <td><?= htmlspecialchars($a['account_code']) ?></td>
                <td><?= htmlspecialchars($a['account_name']) ?></td>
                <td><?= htmlspecialchars($a['account_type']) ?></td>
                <td><?= htmlspecialchars($a['description'] ?? '-') ?></td>
                <td class="text-center">
                  <button class="btn btn-sm btn-info"
                          onclick='openEditModal(<?= json_encode($a) ?>)'>
                    <i class="fas fa-edit"></i>
                  </button>
                  <button class="btn btn-sm btn-danger"
                          onclick="deleteAccount(<?= (int)$a['id'] ?>)">
                    <i class="fas fa-trash"></i>
                  </button>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </section>
  </div>

  <?php include __DIR__ . '/modal-add.php'; ?>
  <?php include __DIR__ . '/modal-edit.php'; ?>
  <?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<!-- JS Libraries -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net@1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/js/dataTables.bootstrap4.min.js"></script>
<script src="assets/js/toast.js"></script>

<script>
$(function() {
  // ✅ Show 10 records per page
  $('#coaTable').DataTable({
    "pageLength": 10,
    "lengthMenu": [10, 25, 50, 100],
    "order": [[0, 'asc']]
  });
});

// ✅ Delete function with confirmation
function deleteAccount(id) {
  if (!confirm('Are you sure you want to delete this account?')) return;

  $.post('public/ajax/coa/delete.php', { id }, function(resp) {
    showToast(resp.message || 'Operation complete', resp.success ? 'success' : 'danger');
    if (resp.success) setTimeout(() => location.reload(), 1000);
  }, 'json');
}
</script>
</body>
</html>
