<!-- Edit Account Modal -->
<div class="modal fade" id="editAccountModal" tabindex="-1" aria-labelledby="editAccountLabel" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-warning text-white">
        <h5 class="modal-title"><i class="fas fa-edit mr-2"></i>Edit Account</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <form id="editAccountForm">
        <input type="hidden" name="id" id="editAccountId">
        <div class="modal-body">
          <div class="form-group">
            <label>Account Name</label>
            <input type="text" name="name" id="editAccountName" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Bank Name</label>
            <input type="text" name="bank_name" id="editBankName" class="form-control">
          </div>
          <div class="form-group">
            <label>Account No</label>
            <input type="text" name="account_no" id="editAccountNo" class="form-control">
          </div>
          <div class="form-group">
            <label>Type</label>
            <select name="type" id="editType" class="form-control">
              <option value="bank">Bank</option>
              <option value="cash">Cash</option>
            </select>
          </div>
          <div class="form-group">
            <label>Remarks</label>
            <textarea name="remarks" id="editRemarks" class="form-control" rows="2"></textarea>
          </div>
        </div>
        <div class="modal-footer bg-light">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-warning text-white"><i class="fas fa-save mr-1"></i>Update</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
function openEditModal(a){
  $('#editAccountId').val(a.id);
  $('#editAccountName').val(a.name);
  $('#editBankName').val(a.bank_name);
  $('#editAccountNo').val(a.account_no);
  $('#editType').val(a.type);
  $('#editRemarks').val(a.remarks);
  $('#editAccountModal').modal('show');
}

$('#editAccountForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/bank/edit-account.php', $(this).serialize(), function(r){
    alert(r.message);
    if(r.status==='success') location.reload();
  }, 'json');
});
</script>
