<?php require_once __DIR__ . '/../../Config/functions.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Bank & Cash Management | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-university mr-2"></i> Bank & Cash Management</h1>
    <button class="btn btn-primary" data-toggle="modal" data-target="#addAccountModal">
      <i class="fas fa-plus-circle"></i> Add Account
    </button>
  </section>

  <section class="content mt-3">
    <div class="row">
      <div class="col-md-4">
        <div class="card">
          <div class="card-header bg-info text-white">Accounts</div>
          <div class="card-body p-2">
            <ul class="list-group">
              <?php foreach($accounts as $a): ?>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <a href="router.php?page=bank&id=<?= $a['id'] ?>">
                  <b><?= htmlspecialchars($a['name']) ?></b><br>
                  <small><?= htmlspecialchars($a['bank_name']) ?></small>
                </a>
                <span class="badge badge-primary p-2">$<?= number_format($a['balance'], 2) ?></span>
              </li>
              <?php endforeach; ?>
            </ul>
          </div>
        </div>
      </div>

      <div class="col-md-8">
        <div class="card">
          <div class="card-header bg-secondary text-white d-flex justify-content-between align-items-center">
            <span>Transactions</span>
            <button class="btn btn-light btn-sm" data-toggle="modal" data-target="#addTransactionModal">
              <i class="fas fa-plus"></i> Add Transaction
            </button>
          </div>
          <div class="card-body table-responsive">
            <table id="txnTable" class="table table-bordered table-striped">
              <thead class="bg-light">
                <tr>
                  <th>Date</th>
                  <th>Description</th>
                  <th>Type</th>
                  <th>Amount (SGD)</th>
                  <th>Ref No</th>
                  <th>Reconciled</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach($transactions as $t): ?>
                <tr>
                  <td><?= $t['txn_date'] ?></td>
                  <td><?= htmlspecialchars($t['description']) ?></td>
                  <td><span class="badge badge-<?= $t['type']=='deposit'?'success':'danger' ?>"><?= ucfirst($t['type']) ?></span></td>
                  <td class="text-right"><?= number_format($t['amount'],2) ?></td>
                  <td><?= htmlspecialchars($t['reference_no']) ?></td>
                  <td>
                    <input type="checkbox" class="reconcileToggle" data-id="<?= $t['id'] ?>" <?= $t['reconciled']?'checked':'' ?>>
                  </td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/modal-add-account.php'; ?>
<?php include __DIR__ . '/modal-transaction.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
  $('#txnTable').DataTable();

  // Reconciliation toggle
  $('.reconcileToggle').on('change', function(){
    const id = $(this).data('id');
    const state = $(this).is(':checked');
    $.post('public/ajax/bank/reconcile.php', {id, state}, function(r){
      console.log(r.message);
    }, 'json');
  });
});
</script>
</body>
</html>
