<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>View Bill | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3><i class="fas fa-file-invoice-dollar mr-2"></i>Bill Details</h3>
    <a href="router.php?page=invoice-print&id=<?= $bill['id'] ?>" target="_blank" class="btn btn-primary">
      <i class="fas fa-print mr-1"></i> Print Invoice
    </a>
  </div>

  <div class="card">
    <div class="card-body">
      <h5>Vendor: <?= htmlspecialchars($bill['vendor_name']) ?></h5>
      <p><?= nl2br(htmlspecialchars($bill['address'])) ?><br>
      GST No: <?= htmlspecialchars($bill['gst_no']) ?></p>
      <hr>
      <table class="table table-sm">
        <tr><th>Bill No</th><td><?= $bill['bill_no'] ?></td></tr>
        <tr><th>Bill Date</th><td><?= $bill['bill_date'] ?></td></tr>
        <tr><th>Due Date</th><td><?= $bill['due_date'] ?></td></tr>
        <tr><th>Total Amount</th><td>$<?= number_format($bill['total_amount'],2) ?></td></tr>
        <tr><th>GST Amount</th><td>$<?= number_format($bill['gst_amount'],2) ?></td></tr>
        <tr><th>Status</th><td><span class="badge badge-info"><?= ucfirst($bill['status']) ?></span></td></tr>
        <tr><th>Remarks</th><td><?= nl2br(htmlspecialchars($bill['remarks'])) ?></td></tr>
      </table>
    </div>
  </div>

  <div class="card mt-3">
    <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
      <h5 class="mb-0">Payments</h5>
      <button class="btn btn-light btn-sm" data-toggle="modal" data-target="#addPaymentModal"
        onclick="$('#paymentBillId').val(<?= $bill['id'] ?>)">Add Payment</button>
    </div>
    <div class="card-body table-responsive">
      <table class="table table-bordered">
        <thead><tr><th>Date</th><th>Method</th><th>Reference</th><th>Amount (SGD)</th><th>Remarks</th></tr></thead>
        <tbody>
          <?php foreach($payments as $p): ?>
            <tr>
              <td><?= $p['payment_date'] ?></td>
              <td><?= $p['method'] ?></td>
              <td><?= htmlspecialchars($p['reference_no']) ?></td>
              <td class="text-right">$<?= number_format($p['amount'],2) ?></td>
              <td><?= htmlspecialchars($p['remarks']) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/payment-add.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>
</body>
</html>
