<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../Controllers/ReportsController.php';
use FPDF\FPDF;

$controller = new ReportsController();
$res = $controller->balanceSheet();

$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',14);
$pdf->Cell(0,10,'Balance Sheet',0,1,'C');
$pdf->Ln(5);
$pdf->SetFont('Arial','',11);

$pdf->SetFillColor(230,230,230);
$pdf->Cell(90,8,'Assets',1,0,'C',true);
$pdf->Cell(90,8,'Liabilities & Equity',1,1,'C',true);

$max = max(count($res['rows']), count($res['rows']));
for($i=0;$i<count($res['rows']);$i++){
    $left = $right = '';
}
foreach($res['rows'] as $r){
    if($r['account_type']==='Asset'){
        $pdf->Cell(90,8,$r['account_name'].'  '.number_format($r['debit']-$r['credit'],2),1,0);
    }
    if(in_array($r['account_type'],['Liability','Equity'])){
        $pdf->Cell(90,8,$r['account_name'].'  '.number_format($r['credit']-$r['debit'],2),1,1);
    }
}

$pdf->Ln(5);
$pdf->SetFont('Arial','B',11);
$pdf->Cell(90,8,'Total Assets: $'.number_format($res['totals']['Asset'],2),0,0);
$pdf->Cell(90,8,'Total L+E: $'.number_format($res['totals']['Liability']+$res['totals']['Equity'],2),0,1);

$pdf->Output('I','Balance_Sheet_'.date('Ymd').'.pdf');
exit;
