<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/Config/database.php';

class Vendor {
    private PDO $db;
    public function __construct(){ $this->db = Database::getConnection(); }

    public function getAll(): array {
        return $this->db->query("SELECT * FROM vendors ORDER BY name ASC")->fetchAll();
    }

    public function getById(int $id): ?array {
        $stmt = $this->db->prepare("SELECT * FROM vendors WHERE id=?");
        $stmt->execute([$id]);
        return $stmt->fetch() ?: null;
    }

    public function create(array $data): bool {
        $sql = "INSERT INTO vendors(name,contact_person,phone,email,address,gst_no,status)
                VALUES(?,?,?,?,?,?,?)";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute([
            $data['name'],$data['contact_person'],$data['phone'],
            $data['email'],$data['address'],$data['gst_no'],'active'
        ]);
    }

    public function update(int $id,array $data): bool {
        $sql = "UPDATE vendors SET name=?,contact_person=?,phone=?,email=?,address=?,gst_no=? WHERE id=?";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute([
            $data['name'],$data['contact_person'],$data['phone'],
            $data['email'],$data['address'],$data['gst_no'],$id
        ]);
    }

    public function delete(int $id): bool {
        $stmt = $this->db->prepare("DELETE FROM vendors WHERE id=?");
        return $stmt->execute([$id]);
    }
}
