<?php
declare(strict_types=1);

class Company
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function getCompany(): ?array
    {
        $stmt = $this->pdo->query("SELECT * FROM company ORDER BY id DESC LIMIT 1");
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    public function getAll(): array
    {
        $stmt = $this->pdo->query("SELECT * FROM company ORDER BY created_at DESC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function add(array $data): bool
    {
        $sql = "INSERT INTO company (name, registration_no, address, phone, email, gst_no, logo_path)
                VALUES (:name, :registration_no, :address, :phone, :email, :gst_no, :logo_path)";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute($data);
    }

    public function update(int $id, array $data): bool
    {
        $sql = "UPDATE company SET name=:name, registration_no=:registration_no, address=:address,
                phone=:phone, email=:email, gst_no=:gst_no, logo_path=:logo_path WHERE id=:id";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute($data);
    }

    public function delete(int $id): bool
    {
        $stmt = $this->pdo->prepare("DELETE FROM company WHERE id=?");
        return $stmt->execute([$id]);
    }

    public function find(int $id): ?array
    {
        $stmt = $this->pdo->prepare("SELECT * FROM company WHERE id=?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }
}
