<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/Config/functions.php';
require_once __DIR__ . '/../../app/Models/TrialBalance.php';
require_once __DIR__ . '/../../app/Models/ProfitLoss.php';
require_once __DIR__ . '/../../app/Models/BalanceSheet.php';
require_once __DIR__ . '/../../app/Models/CashFlow.php';

class ReportsController
{
    /**
     * Display the Trial Balance report.
     */
    public function trialBalance(): void
    {
        require_login();

        $model = new TrialBalance();
        $start = $_GET['start'] ?? null;
        $end   = $_GET['end'] ?? null;
        $rows  = $model->getTrialBalance($start, $end);

        include __DIR__ . '/../../app/Views/reports/trial-balance.php';
    }

    /**
     * Display the Profit & Loss Statement.
     */
    public function profitLoss(): void
    {
        require_login();

        $model = new ProfitLoss();
        $start = $_GET['start'] ?? null;
        $end   = $_GET['end'] ?? null;
        $data  = $model->getProfitLoss($start, $end);

        include __DIR__ . '/../../app/Views/reports/profit-loss.php';
    }

    /**
     * Display the Balance Sheet Statement.
     */
    public function balanceSheet(): void
    {
        require_login();

        $model = new BalanceSheet();
        $start = $_GET['start'] ?? null;
        $end   = $_GET['end'] ?? null;
        $data  = $model->getBalanceSheet($start, $end);

        include __DIR__ . '/../../app/Views/reports/balance-sheet.php';
    }

    /**
     * Display the Cash Flow Statement.
     */
    public function cashFlow(): void
    {
        require_login();

        $model = new CashFlow();
        $start = $_GET['start'] ?? null;
        $end   = $_GET['end'] ?? null;
        $data  = $model->getCashFlow($start, $end);

        include __DIR__ . '/../../app/Views/reports/cashflow.php';
    }
}
