<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/Models/Journal.php';
require_once __DIR__ . '/../../app/Models/JournalLine.php';
require_once __DIR__ . '/../../app/Config/functions.php';

class JournalController {
    public function index(): void {
        require_login();
        $model = new Journal();
        $journals = $model->getAll();
        include __DIR__ . '/../../app/Views/journal/index.php';
    }

    public function view(int $id): void {
        require_login();
        $model = new Journal();
        $lines = new JournalLine();
        $journal = $model->getById($id);
        $entries = $lines->getByJournalId($id);
        include __DIR__ . '/../../app/Views/journal/view.php';
    }
}
