<?php
declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

use Dotenv\Dotenv;

// --------------------------------------------------------------------------
//  Composer Autoload (Loads Dotenv, FPDF, etc.)
// --------------------------------------------------------------------------
require_once __DIR__ . '/../../vendor/autoload.php';

// --------------------------------------------------------------------------
//  Environment Variables (.env loader)
// --------------------------------------------------------------------------
$dotenv = Dotenv::createImmutable(__DIR__ . '/../../');
$dotenv->safeLoad();

// --------------------------------------------------------------------------
//  Global Constants
// --------------------------------------------------------------------------
define('BASE_PATH', dirname(__DIR__, 2));
define('BASE_URL', $_ENV['BASE_URL'] ?? 'http://accounting/');
define('APP_NAME', 'SGAccount');

// --------------------------------------------------------------------------
//  Include Global Helper Functions Automatically
// --------------------------------------------------------------------------
// ✅ This ensures csrf_token(), post(), get(), etc. are always available
require_once __DIR__ . '/functions.php';

// --------------------------------------------------------------------------
//  Start Session (Safe for any context)
// --------------------------------------------------------------------------
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
